/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.atom;

import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.ElementProperties;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PropertiesBasedAtom;
import edu.colorado.phet.common.quantum.model.QuantumModel;
import edu.colorado.phet.lasers.model.LaserModel;

public class LaserAtom
extends PropertiesBasedAtom {
    private Boolean canCollideInGroundState = Boolean.TRUE;

    public LaserAtom(LaserModel laserModel, ElementProperties elementProperties) {
        super((QuantumModel)laserModel, elementProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collideWithPhoton(Photon photon) {
        boolean bl = false;
        if (this.getCurrState() != this.getGroundState()) {
            bl = true;
        } else {
            Boolean bl2 = this.canCollideInGroundState;
            synchronized (bl2) {
                bl = this.canCollideInGroundState;
            }
        }
        if (bl) {
            super.collideWithPhoton(photon);
        }
    }

    public void setCurrState(AtomicState atomicState) {
        super.setCurrState(atomicState);
        if (atomicState == this.getGroundState() && this.canCollideInGroundState != null) {
            new MinLifetimeTimer().start();
        }
    }

    public void setStates(AtomicState[] atomicStateArray) {
        super.setStates(atomicStateArray);
        atomicStateArray[1] = ((LaserModel)this.getModel()).getMiddleEnergyState();
        if (atomicStateArray.length == 3) {
            atomicStateArray[2] = ((LaserModel)this.getModel()).getHighEnergyState();
        }
    }

    private class MinLifetimeTimer
    extends Thread {
        long minLifetime = 200L;

        private MinLifetimeTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Boolean bl = LaserAtom.this.canCollideInGroundState;
            synchronized (bl) {
                LaserAtom.this.canCollideInGroundState = Boolean.FALSE;
            }
            try {
                Thread.sleep(this.minLifetime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            bl = LaserAtom.this.canCollideInGroundState;
            synchronized (bl) {
                LaserAtom.this.canCollideInGroundState = Boolean.TRUE;
            }
        }
    }
}

